<!doctype html>
<html lang="es">
<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Resum Pressupost</title>
<!-- Main css -->
<?php
if(isset($empresa[0])){
    $colorPrimari = $empresa[0]->color_p_disseny;
    $colorSecundari = $empresa[0]->color_s_disseny;
}else{
    $colorPrimari = '#1dbfb9';
    $colorSecundari = '#d6f3f1';
}
$boostrap = file_get_contents('https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.css');
$style = file_get_contents(base_url().'/dist/css/style.css');
?>
<style type="text/css">
<?= $boostrap; ?>
</style>
<style type="text/css">
:root {
  --primary: <?= $colorPrimari ?>;
  --secondary: <?= $colorSecundari ?>;
}
.desc-resum {
    line-height: 24px !important;
}
.result-legal ul li {
    margin-bottom: 0px !important;
    line-height: 27px !important;
}
.result-c ul.result-li-w li.result-li-c p {
    margin: 0px !important;
    line-height: 30px !important;
}
.info-client-resum li.result-li-c {
    margin: 0px !important;
    line-height: 40px !important;
}
</style>
</head>
<body>

    <div class="wrapper">
        <div id="header">
            <nav class="navbar navbar-light">
                <div class="container text-center">
                    <?php
                    $logo = base_url().'/uploads/empreses/'.$empresa[0]->logo_disseny;
                    $logoBase64 = "data:image/png;base64," . base64_encode(file_get_contents($logo));
                    ?>
                    <a class="navbar-brand" href="<?= base_url() ?>/?s=1">
                    <img src="<?= $logoBase64 ?>" alt="" width="200" height="auto">
                    </a>
                </div>
            </nav>
        </div>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
                
            <div id="cost-sections">
                <div class="container-fluid pt-5 pb-5 container-box-c">
                    <form id="form-resum" method="post" action="#" enctype="multipart/form-data">
                        <div class="project-info-section">
                            <div class="section-option-total container-medium text-center">
                                <h2 class="title-cost">Pressupost</h2>
                                <p class="subtitle-cost">
                                    El preu final és:
                                </p>
                                <h3 class="title-cost title-total" style="color: <?= $colorPrimari ?>"><?= $pressupost->preu_pressupost ?>€</h3>
                                <ul class="info-client-resum">
                                    <li>
                                        <b>Nº Pressupost:</b> #<?= $pressupost->num_pressupost ?>
                                    </li>
                                    <li>
                                        <b>Data:</b> <?= $pressupost->data_pressupost ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="section-option-total section-option-total-last container-large">
                                <h3 class="title-cost text-center">Resum</h3>
                                <br>
                                <div class="result-list-c">
                                    <h4 class="title-result-c" style="background-color: <?= $colorPrimari ?>">Descripció</h4>
                                    <div class="result-c">
                                        <ul class="result-li-w">
                                        <?= $pressupost->resum_pressupost ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="result-legal container-large">
                                <ul>
                                    <li>
                                        El present pressupost té una validesa de 30 dies naturals a partir de la data que figura en el mateix.
                                    </li>
                                    <li>
                                        En cas que el projecte quedi aturat durant més de 45 dies per part del client, sense que faciliti el material necessari per a finalitzar el projecte, es procedirà a facturar la part del procediment fins a la data. Si es reprèn el projecte, es realitzarà un nou pressupost corresponent a les noves tasques a realitzar.
                                    </li>
                                    <li>
                                        El material necessari per part del client serà entregat, amb els formats prèviament definits per part de Grafix
                                    </li>
                                    <li>
                                        Qualsevol modificació del material requerit per part de l’empresa, es facturarà a banda del pressupost, en hores de treball.
                                    </li>
                                    <li>
                                        En cas d’una modificació del pressupost original, es realitzarà un nou pressupost o es facturarà en hores de treball depenent de la valoració de la modificació a realitzar.
                                    </li>
                                    <li>
                                        A l’inici del projecte s'emetrà una factura del 60% de l’import del pressupost del projecte, com a provisió de fons dels serveis a realitzar. Una vegada acabat el projecte, es facturarà l’altre 40 % restant.
                                    *en el cas que el projecte inclogui allotjament extern a Grafix, s’enviaran els arxius del projecte un cop abonat el 100% del pressupost del projecte.
                                    </li>
                                    <li>
                                        Grafix no es fa responsable de les possibles incidències dels recursos externs, en el cas que s’utilitzin en el projecte.
                                    </li>
                                    <li>
                                        En el cas de canvis de la normativa legal, posteriors al projecte, Grafix no es farà responsable del manteniment ni actualització dels textos, sempre que no estigui prèviament definit en el pressupost original.
                                    *Es recomanable concertar el servei de manteniment/pack d’hores, per tal de tindre la web constantment actualitzada.
                                    </li>
                                    <li>
                                        Grafix  garanteix la confidencialitat del projecte durant tot el procediment de desenvolupament.
                                    </li>
                                    <li>
                                        <b>Un cop entregat el projecte, Grafix es reserva el dret a utilitzar-lo per a usos publicitaris (web, xarxes socials, mostra de projectes realitzats, entre altres).</b>
                                    </li>
                                </ul>
                            </div>
                            <div class="acceptance container-medium">
                                <h3 class="title-cost" style="color: #000">Signatura</h3>
                                <div class="signature-result">
                                    <?php
                                    $signatura = base_url().'/uploads/signatures/'.$pressupost->signatura_pressupost;
                                    $signaturaBase64 = "data:image/png;base64," . base64_encode(file_get_contents($signatura));
                                    ?>
                                    <img src="<?= (isset($signaturaBase64))?$signaturaBase64:base_url().'/dist/img/logo-grafix.png'; ?>" class="img-fluid" style="width:300px;height:100px;border: 1px solid #1dbfb9;border-radius:5px">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

<!-- Option 2: Separate Popper and Bootstrap JS -->
<!--
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js" integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js" integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13" crossorigin="anonymous"></script>
-->
</body>
</html>